import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:get/get.dart';
import 'package:viserpay_merchant/core/utils/my_color.dart';
import 'package:viserpay_merchant/core/utils/my_strings.dart';
import 'package:viserpay_merchant/core/utils/dimensions.dart';
import 'package:viserpay_merchant/core/utils/style.dart';
import 'package:viserpay_merchant/core/utils/util.dart';
import 'package:viserpay_merchant/data/controller/withdraw/add_withdraw_method_controller.dart';
import 'package:viserpay_merchant/data/controller/withdraw/withdraw_money_controller.dart';
import 'package:viserpay_merchant/data/model/global/formdata/global_keyc_form_data.dart';
import 'package:viserpay_merchant/data/repo/withdraw/add_withdraw_method_repo.dart';
import 'package:viserpay_merchant/data/services/api_service.dart';
import 'package:viserpay_merchant/view/components/app-bar/custom_appbar.dart';
import 'package:viserpay_merchant/view/components/bottom-sheet/custom_bottom_sheet.dart';
import 'package:viserpay_merchant/view/components/buttons/gradient_rounded_button.dart';
import 'package:viserpay_merchant/view/components/buttons/rounded_button.dart';
import 'package:viserpay_merchant/view/components/buttons/rounded_loading_button.dart';
import 'package:viserpay_merchant/view/components/checkbox/custom_check_box.dart';
import 'package:viserpay_merchant/view/components/custom_loader/custom_loader.dart';
import 'package:viserpay_merchant/view/components/custom_radio_button.dart';
import 'package:viserpay_merchant/view/components/form_row.dart';
import 'package:viserpay_merchant/view/components/text-form-field/custom_drop_down_text_field.dart';
import 'package:viserpay_merchant/view/components/text-form-field/custom_text_field.dart';
import 'package:viserpay_merchant/view/components/text/label_text.dart';
import 'package:viserpay_merchant/view/screens/auth/kyc/section/kyc_checkbox_section.dart';
import 'package:viserpay_merchant/view/screens/auth/kyc/section/kyc_date_time_section.dart';
import 'package:viserpay_merchant/view/screens/auth/kyc/section/kyc_radio_section.dart';
import 'package:viserpay_merchant/view/screens/auth/kyc/section/kyc_select_section.dart';
import 'package:viserpay_merchant/view/screens/auth/kyc/section/kyc_text_section.dart';
import 'package:viserpay_merchant/view/screens/auth/kyc/widget/widget/choose_file_list_item.dart';
import 'package:viserpay_merchant/view/screens/transaction/widget/filter_row_widget.dart';
import 'package:viserpay_merchant/view/screens/withdrawals/withdraw_method/widget/add_withdraw_method_bottom_sheet.dart';
import '../../../../../data/model/withdraw/add_withdraw_method_response_model.dart' as withdraw;

class AddWithdrawMethodScreen extends StatefulWidget {
  const AddWithdrawMethodScreen({super.key});

  @override
  State<AddWithdrawMethodScreen> createState() => _AddWithdrawMethodScreenState();
}

class _AddWithdrawMethodScreenState extends State<AddWithdrawMethodScreen> {
  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(AddWithdrawMethodRepo(apiClient: Get.find()));
    final controller = Get.put(AddWithdrawMethodController(addWithdrawMethodRepo: Get.find()));
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.loadData();
    });
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<AddWithdrawMethodController>(
      builder: (controller) => AnnotatedRegion<SystemUiOverlayStyle>(
        value: SystemUiOverlayStyle.dark.copyWith(statusBarColor: MyColor.colorWhite),
        child: Scaffold(
          backgroundColor: MyColor.getScreenBgColor(),
          appBar: CustomAppBar(
            title: MyStrings.addWithdrawMethod.tr,
            bgColor: MyColor.getAppBarColor(),
          ),
          body: controller.isLoading
              ? const CustomLoader()
              : SingleChildScrollView(
                  padding: Dimensions.screenPaddingHV,
                  child: Container(
                    decoration: BoxDecoration(
                      color: MyColor.colorWhite,
                      borderRadius: BorderRadius.circular(Dimensions.defaultRadius),
                    ),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        // Padding(
                        //   // padding: Dimensions.screenPaddingHV,
                        //   padding: const EdgeInsets.symmetric(horizontal: Dimensions.space15, vertical: Dimensions.space10),
                        //   child: Text(
                        //     MyStrings.enterDetails.tr,
                        //     style: boldOverLarge.copyWith(color: MyColor.colorBlack),
                        //   ),
                        // ),
                        // Container(
                        //   margin: const EdgeInsets.only(top: 0, bottom: Dimensions.space20),
                        //   width: double.infinity,
                        //   height: 1,
                        //   color: MyColor.colorBlack.withOpacity(0.3),
                        // ),
                        Padding(
                          padding: const EdgeInsets.symmetric(horizontal: Dimensions.space15, vertical: Dimensions.space25),
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              const LabelText(text: MyStrings.selectMethod),
                              const SizedBox(height: Dimensions.textToTextSpace),
                              SizedBox(
                                height: 50,
                                child: FilterRowWidget(
                                    borderColor: controller.selectedMethod?.id.toString() == "-1" ? MyColor.textFieldDisableBorderColor : MyColor.textFieldEnableBorderColor, text: "${controller.selectedMethod?.id.toString() == "-1" ? MyStrings.selectMethod : controller.selectedMethod?.name}", press: () => CustomBottomSheet(child: const AddWithdrawMethodBottomSheet()).customBottomSheet(context)),
                              ),
                              const SizedBox(height: Dimensions.space15),
                              const SizedBox(height: Dimensions.space15),
                              CustomTextField(
                                needOutlineBorder: true,
                                isRequired: true,
                                controller: controller.nameController,
                                labelText: MyStrings.provideNickName.tr,
                                hintText: '',
                                onChanged: (value) {},
                              ),
                              Visibility(
                                visible: true,
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    const SizedBox(height: Dimensions.space15),
                                    ListView.builder(
                                      shrinkWrap: true,
                                      physics: const NeverScrollableScrollPhysics(),
                                      scrollDirection: Axis.vertical,
                                      itemCount: controller.formList.length,
                                      itemBuilder: (ctx, index) {
                                        GlobalFormModel? model = controller.formList[index];
                                        return Padding(
                                          padding: const EdgeInsets.all(3),
                                          child: Column(
                                            crossAxisAlignment: CrossAxisAlignment.start,
                                            mainAxisSize: MainAxisSize.min,
                                            children: [
                                              if (MyUtils.getTextInputType(model.type ?? 'text')) ...[
                                                KycTextAnEmailSection(
                                                  onChanged: (value) {
                                                    controller.changeSelectedValue(value, index);
                                                  },
                                                  model: model,
                                                )
                                              ] else if (model.type == "select") ...[
                                                KycSelectSection(
                                                  onChanged: (value) {
                                                    controller.changeSelectedValue(value, index);
                                                  },
                                                  model: model,
                                                )
                                              ] else if (model.type == 'radio') ...[
                                                KycRadioSection(
                                                  model: model,
                                                  onChanged: (selectedIndex) {
                                                    controller.changeSelectedRadioBtnValue(index, selectedIndex);
                                                  },
                                                  selectedIndex: controller.formList[index].options?.indexOf(model.selectedValue ?? '') ?? 0,
                                                )
                                              ] else if (model.type == "checkbox") ...[
                                                KycCheckBoxSection(
                                                  model: model,
                                                  onChanged: (value) {
                                                    controller.changeSelectedCheckBoxValue(index, value);
                                                  },
                                                  selectedValue: controller.formList[index].cbSelected,
                                                )
                                              ] else if (model.type == "datetime" || model.type == "date" || model.type == "time") ...[
                                                KycDateTimeSection(
                                                  model: model,
                                                  onChanged: (value) {
                                                    controller.changeSelectedValue(value, index);
                                                  },
                                                  onTap: () {
                                                    print(model.type);
                                                    if (model.type == "time") {
                                                      controller.changeSelectedTimeOnlyValue(index, context);
                                                    } else if (model.type == "date") {
                                                      controller.changeSelectedDateOnlyValue(index, context);
                                                    } else {
                                                      controller.changeSelectedDateTimeValue(index, context);
                                                    }
                                                  },
                                                  controller: controller.formList[index].textEditingController!,
                                                )
                                              ],
                                              model.type == 'file'
                                                  ? Column(
                                                      crossAxisAlignment: CrossAxisAlignment.start,
                                                      children: [
                                                        FormRow(label: model.name?.tr ?? '', isRequired: model.isRequired == 'optional' ? false : true),
                                                        Padding(
                                                            padding: const EdgeInsets.symmetric(vertical: Dimensions.textToTextSpace),
                                                            child: SizedBox(
                                                              child: InkWell(
                                                                  onTap: () {
                                                                    controller.pickFile(index);
                                                                  },
                                                                  child: ChooseFileItem(fileName: model.selectedValue ?? MyStrings.chooseFile)),
                                                            ))
                                                      ],
                                                    )
                                                  : const SizedBox(),
                                              const SizedBox(height: Dimensions.space10),
                                            ],
                                          ),
                                        );
                                      },
                                    )
                                  ],
                                ),
                              ),
                              const SizedBox(height: Dimensions.space25),
                              GradientRoundedButton(
                                press: () {
                                  controller.submitData();
                                },
                                text: MyStrings.addWithdrawMethod,
                                showLoadingIcon: controller.submitLoading,
                              ),
                            ],
                          ),
                        )
                      ],
                    ),
                  ),
                ),
        ),
      ),
    );
  }
}
